/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.reflection.entity.item;

import java.lang.reflect.Field;
import net.minecraft.entity.item.EntityItem;
import noppes.npcs.LogWriter;

public class EntityItemReflection {
    private static Field age;

    public static int getAge(EntityItem item) {
        if (item == null) {
            return 0;
        }
        try {
            Field field = EntityItemReflection.getAgeField();
            field.setAccessible(true);
            return (Integer)field.get(item);
        }
        catch (Exception e) {
            LogWriter.error("Error get \"age\" in " + item, e);
            return 0;
        }
    }

    public static void setAge(EntityItem item, int newAge) {
        if (item == null) {
            return;
        }
        newAge = (int)Math.max(Math.min((long)newAge, Integer.MAX_VALUE), 0L);
        try {
            Field field = EntityItemReflection.getAgeField();
            field.setAccessible(true);
            field.set(item, newAge);
        }
        catch (Exception e) {
            LogWriter.error("Error set \"age\":\"" + newAge + "\" in " + item, e);
        }
    }

    private static Field getAgeField() {
        if (age == null) {
            Exception error = null;
            try {
                age = EntityItem.class.getDeclaredField("field_70292_b");
            }
            catch (Exception e) {
                error = e;
            }
            if (age == null) {
                try {
                    age = EntityItem.class.getDeclaredField("age");
                    error = null;
                }
                catch (Exception e) {
                    error = e;
                }
            }
            if (error != null) {
                LogWriter.error("Error found field \"age\"", error);
            }
        }
        return age;
    }
}

